#version 330
#extension GL_EXT_gpu_shader4 : enable
// Twisty Slime CylinderMod01.fsh by Del

//https://www.shadertoy.com/view/XlsfzX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec4 Slime(vec2 uv)
{
    const vec4 col1 = vec4(0.0,.1,.1,1.0);
    const vec4 col2 = vec4(0.5,0.9,0.3,1.0);
    
    vec4 k = vec4(0.0);
    
    float s = sin(iTime*0.1);
    float s2 = 0.5+sin(iTime*1.8);
    vec2 d = uv*(3.0+s*.3);						// mod 4.0 for irregularity...
    
    d.x += iTime*0.3+sin(d.x+d.y + iTime*0.3)*0.5;
    d.y += iTime*0.15+sin(d.x + iTime*0.3)*0.5;	//-(s*0.5);
    float v1=length(0.5-fract(d.xy))+0.55;				// 0.9 =more gooey bits, 1.2 = less gooey bits

    d = (uv);			// zoom
    float v2=length(0.5-fract(d.xx))-0.175;		// border
    v1 *= 1.0-v2*v1;
    v1 = v1*v1*v1;
    v1 *= 2.9+s2*0.2;
    k = mix(col2,col1,v1)*(3.2+(s2*0.2));
    k *= 1.0-(v2);
    
    if (k.g<=0.4)
    {
        float m = 1.0-clamp(k.g,0.0,0.5);
		float f = mod( floor(6.0*uv.x) + floor(6.0*uv.y), 2.0);
        float col = 0.3 + 0.2*f*1.0;
        k.x = k.y = k.z = col*m;
		k.rb *= 1.2;
    }
    else
    {
		float f = mod( floor(6.0*uv.x) + floor(6.0*uv.y), 2.0);
        vec4 _col = 0.2*f*vec4(0.175);
        k+=_col;
    }
    return k;
}

// mirror mod
float pModMirror1(inout float p, float size)
{
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize,size) - halfsize;
	p *= mod(c, 2.0)*2. - 1.;
	return c;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (2.*gl_FragCoord.xy - iResolution.xy)/ iResolution.y;
    
    float speed = iTime*0.15;
    float _fd = iTime*0.4;
    vec2 cst = vec2( cos(_fd), sin(_fd) );
    float zoom = 2.0+sin(speed)*0.5;
    mat2 rot = mat2(cst.x,-cst.y,cst.y,cst.x) * zoom;
    uv = rot*uv;

	float t = iTime*0.5;
    
    uv.y *= 0.5;

    // click mouse for many... :)
    if (iMouse.z>0.5)
    {
        // repeat :)
        uv *= 1.25;		// extra zoom
        float dist = abs(sin(iTime*0.9));
        dist = 2.+smoothstep(0.0,4.0,dist*3.0);
        pModMirror1(uv.x,dist);
    }

    float c = abs(uv.x);		// dirty shading bodge...
    
	gl_FragColor = vec4(0.3,0.3,0.6,1.0);
	//gl_FragColor = vec4(0.3,0.3,0.6,1.0)*(3.0-c);
    if (c-0.5 < 0.5)
    {
		uv.x = acos(uv.x)/3.14159;
		uv.x += sin(t+uv.y*0.7);
        c = acos(c);
        //c=smoothstep(1.4,0.1,c*c*c*c);
        gl_FragColor = Slime(uv*3.0)*c;
        //gl_FragColor=vec4(c);
    }
}